#!/bin/bash

session="$1"
device=1
environment='path/to/env' # Change for submission
name='coun'
data_path='./data'
dataset='CIFAR10'
model_type='resnet18'
forget_data_ratio=0.1
num_epochs=50

file_location=algs.coun

checkpoint_path='path/to/original/converged/model/'

tmux new-session -d -s $session

window=0
tmux rename-window -t $session:$window $name
tmux send-keys -t $session:$window "source activate $environment" C-m
tmux send-keys -t $session:$window "python -m $file_location --data_path=$data_path --dataset=$dataset --name=$name --num_epochs=$num_epochs --model_type=$model_type  --checkpoint_path=$checkpoint_path --forget_data_ratio=$forget_data_ratio --device=$device" C-m

tmux attach-session -t $session